<?php

namespace DZ\Server\Admin\Controller;

use XF\Admin\Controller\AbstractController;
use XF\Mvc\ParameterBag;
use XF\Mvc\Reply\View;

class Status extends AbstractController
{
    public function actionIndex(ParameterBag $params): View|\XF\Mvc\Reply\AbstractReply
    {
        // Provjera AJAX osvježavanja
        $dzRefresh = $this->filter('dz-refresh', 'uint');

        if ($dzRefresh === 1) {
            // DIREKTNI JSON – izbjegava XF render pipeline
            $serverInfo = $this->service('DZ\Server:ServerInfo');
            $data = $serverInfo->getServerData();

            header('Content-Type: application/json');
            echo json_encode($data, JSON_PRETTY_PRINT);
            exit;
        }

        // Standardno prikazivanje admin stranice
        $serverInfo = $this->service('DZ\Server:ServerInfo');
        $serverData = $serverInfo->getServerData();

        return $this->view(
            'DZ\Server:Status\Index',
            'dz_server_status_index',
            [
                'serverData' => $serverData
            ]
        );
    }

    protected function preDispatchController($action, ParameterBag $params)
    {
        // Dozvoljavamo samo adminima s node permission (isto kao original)
        $this->assertAdminPermission('node');
    }
}
