<?php

namespace DZ\LinkToTools\Option;

use XF\Entity\Option;
use XF\Option\AbstractOption;

class ToolsInfo extends AbstractOption
{
    public static function render(Option $option, array $htmlParams)
    {
        $app = \XF::app();
        $adminRouter = $app->router('admin');

        $infoLink = $adminRouter->buildLink('dz-tools');
        $toolsPath = \XF::getRootDirectory() . '/tools';
        $toolsExists = is_dir($toolsPath);

        $statusLabel = $toolsExists
            ? '<span class="dzToolsStatus dzToolsStatus--ok">Installed</span>'
            : '<span class="dzToolsStatus dzToolsStatus--missing">Not installed</span>';

        return '
<style>
.dzToolsOptionCard {
    background: #fff;
    border: 1px solid #dcdfe4;
    border-radius: 6px;
    padding: 16px 18px;
    box-shadow: 0 2px 6px rgba(0,0,0,.04);
}

.dzToolsOptionHeader {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
}

.dzToolsOptionTitle {
    font-size: 15px;
    font-weight: 600;
}

.dzToolsOptionDesc {
    color: #6c757d;
    font-size: 13px;
    margin-bottom: 14px;
}

.dzToolsStatus {
    font-size: 12px;
    font-weight: 600;
    padding: 3px 10px;
    border-radius: 999px;
}

.dzToolsStatus--ok {
    background: #e6f4ea;
    color: #137333;
}

.dzToolsStatus--missing {
    background: #fdecea;
    color: #b31412;
}

.dzToolsOptionActions {
    display: flex;
    gap: 10px;
}
</style>

<div class="dzToolsOptionCard">

    <div class="dzToolsOptionHeader">
        <div class="dzToolsOptionTitle">
            DZ Tools
        </div>
        ' . $statusLabel . '
    </div>

    <div class="dzToolsOptionDesc">
        Central administration toolkit for XenForo development.<br>
        Provides addon scaffolding, hash generation, release builds,
        Redis monitoring and direct configuration management.
    </div>

    <div class="dzToolsOptionActions">
        <a href="' . htmlspecialchars($infoLink) . '"
           class="button button--primary">
            Open DZ Tools Info & Installer
        </a>
    </div>

</div>';
    }
}
