<?php

namespace DZ\LinkToTools\Admin\Controller;

use XF\Admin\Controller\AbstractController;
use XF\Mvc\ParameterBag;

class Tools extends AbstractController
{
    protected function getForumRoot(): string
    {
        return \XF::getRootDirectory();
    }

    protected function getToolsPath(): string
    {
        return $this->getForumRoot() . '/tools';
    }

    public function actionIndex(ParameterBag $params)
    {
        $toolsPath = $this->getToolsPath();
        $toolsExists = is_dir($toolsPath);

        $viewParams = [
            'toolsExists' => $toolsExists,
            'toolsUrl'    => \XF::app()->request()->getBasePath() . '/tools/index.php'
        ];

        return $this->view(
            'DZ\ToolsLink:Tools\Index',
            'dz_toolslink_info',
            $viewParams
        );
    }

    public function actionInstall(ParameterBag $params)
    {
        $this->assertPostOnly();

        $toolsPath = $this->getToolsPath();

        if (is_dir($toolsPath)) {
            return $this->error(\XF::phrase('dz_tools_already_installed'));
        }

        $tmpFile = tempnam(sys_get_temp_dir(), 'dz_tools_');
        $zipUrl  = 'https://downzone.org/file/tools.zip';

        $zipData = @file_get_contents($zipUrl);
        if ($zipData === false) {
            return $this->error(\XF::phrase('dz_tools_download_failed'));
        }

        file_put_contents($tmpFile, $zipData);

        $zip = new \ZipArchive();
        if ($zip->open($tmpFile) !== true) {
            @unlink($tmpFile);
            return $this->error(\XF::phrase('dz_tools_zip_invalid'));
        }

        if (!$zip->extractTo($this->getForumRoot())) {
            $zip->close();
            @unlink($tmpFile);
            return $this->error(\XF::phrase('dz_tools_extract_failed'));
        }

        $zip->close();
        @unlink($tmpFile);

        return $this->redirect(
            $this->buildLink('dz-tools'),
            \XF::phrase('dz_tools_install_success')
        );
    }
}
