<?php

namespace DZ\InfoBlocks\Service;

use XF\Service\AbstractService;

class BlockContent extends AbstractService
{
    /**
     * Dohvat svih info blokova
     */
    public function getBlocks(): array
    {
        $blocks = [];

        for ($i = 1; $i <= 10; $i++)
        {
            $enabled = $this->app->options->{'info_blocks_block' . $i . '_enable'} ?? false;
            if (!$enabled)
            {
                continue;
            }

            $mode = $this->app->options->{'info_blocks_block' . $i . '_mode'} ?? 'manual';

            if ($mode === 'forum')
            {
                $forumBlock = $this->getForumBlock($i);
                if ($forumBlock !== null)
                {
                    $blocks[] = $forumBlock;
                }

                // VAŽNO: nema fallbacka na manual
                continue;
            }

            // MANUAL MODE
            $blocks[] = $this->getManualBlock($i);
        }

        return $blocks;
    }

    /**
     * Manual blok
     */
    protected function getManualBlock(int $blockId): array
    {
        return [
            'mode'    => 'manual',
            'enabled' => true,
            'icon'    => $this->app->options->{'info_blocks_block' . $blockId . '_icon'},
            'title'   => $this->app->options->{'info_blocks_block' . $blockId . '_title'},
            'text'    => $this->app->options->{'info_blocks_block' . $blockId . '_text'},
            'link'    => $this->app->options->{'info_blocks_block' . $blockId . '_link'},
        ];
    }

    /**
     * Forum (auto) blok
     */
    protected function getForumBlock(int $blockId): ?array
    {
        $nodeId = (int) ($this->app->options->{'info_blocks_block' . $blockId . '_forum_node_id'} ?? 0);
        if ($nodeId <= 0)
        {
            return null;
        }

        $limit = (int) ($this->app->options->{'info_blocks_block' . $blockId . '_forum_limit'} ?? 5);
        $ttl   = (int) ($this->app->options->{'info_blocks_block' . $blockId . '_cache_ttl'} ?? 0);

        $cacheKey = 'dz_info_blocks_forum_' . $blockId;

        if ($ttl > 0)
        {
            $cached = $this->app->cache()->fetch($cacheKey);
            if ($cached !== false)
            {
                return $cached;
            }
        }

        $finder = $this->app->finder('XF:Thread')
            ->where('node_id', $nodeId)
            ->where('discussion_state', 'visible')
            ->order('post_date', 'DESC')
            ->limit($limit);

        $threads = $finder->fetch();
        if (!$threads->count())
        {
            return null;
        }

        $items = [];
        foreach ($threads as $thread)
        {
            $items[] = [
                'title'   => $thread->title,
                'link'    => $this->app->router('public')->buildLink('threads', $thread),
                'excerpt' => $thread->FirstPost ? $thread->FirstPost->message : '',
            ];
        }

        $block = [
            'mode'  => 'forum',
            'icon'  => $this->app->options->{'info_blocks_block' . $blockId . '_icon'},
            'items' => $items,
        ];

        if ($ttl > 0)
        {
            $this->app->cache()->save($cacheKey, $block, $ttl * 3600);
        }

        return $block;
    }
}
