<?php

namespace DZ\InfoBlocks\Listener;

use XF\Container;
use XF\Template\Templater;

class TemplaterSetup
{
    /**
     * XenForo 2.3 templater_setup event
     *
     * @param Container $container
     * @param Templater $templater
     */
    public static function templaterSetup(Container $container, Templater $templater): void
    {
        // Dohvat XF aplikacije
        $app = \XF::app();

        // Service za Info Blocks
        $service = $app->service('DZ\InfoBlocks:BlockContent');
        $blocks  = $service->getBlocks();

        // Globalno dostupno u svim templateima
        $templater->addDefaultParam('infoBlocks', $blocks);
    }
}
