<?php

namespace DZ\AutoDelete\XF\Cron;

class AutoDelete
{
    protected static $batchSize = 50;

    public static function runAutoDelete()
    {
        $options = \XF::options();

        $forums = [
            ['id' => $options->AutoDeleteForum1, 'days' => $options->AutoDeleteDays1],
            ['id' => $options->AutoDeleteForum2, 'days' => $options->AutoDeleteDays2],
            ['id' => $options->AutoDeleteForum3, 'days' => $options->AutoDeleteDays3],
            ['id' => $options->AutoDeleteForum4, 'days' => $options->AutoDeleteDays4],
            ['id' => $options->AutoDeleteForum5, 'days' => $options->AutoDeleteDays5],
            ['id' => $options->AutoDeleteForum6, 'days' => $options->AutoDeleteDays6],
            ['id' => $options->AutoDeleteForum7, 'days' => $options->AutoDeleteDays7],
            ['id' => $options->AutoDeleteForum8, 'days' => $options->AutoDeleteDays8],
            ['id' => $options->AutoDeleteForum9, 'days' => $options->AutoDeleteDays9],
            ['id' => $options->AutoDeleteForum10, 'days' => $options->AutoDeleteDays10],
        ];

        // Filter praznih
        $forums = array_filter($forums, function ($forum) {
            return !empty($forum['id']) && $forum['days'] > 0;
        });

        if (empty($forums)) {
            return;
        }

        $hardDelete = $options->AutoDeleteHardDelete;

        // Učitavanje spremljenog napretka
        $lastRunRaw = $options->dzAutoDelete_lastRun;

        if ($lastRunRaw === '' || $lastRunRaw === null) {
            $lastRun = [];
        } else {
            $lastRun = @json_decode($lastRunRaw, true);
            if (!is_array($lastRun)) {
                $lastRun = [];
            }
        }

        $totalDeleted = 0;

        foreach ($forums as $forum) {
            $forumId = (int)$forum['id'];
            $days    = (int)$forum['days'];

            $cutoff = time() - ($days * 86400);

            $lastThreadId = isset($lastRun[$forumId]) ? (int)$lastRun[$forumId] : 0;

            $finder = \XF::finder('XF:Thread');
            $threads = $finder
                ->where('node_id', $forumId)
                ->where('last_post_date', '<', $cutoff)
                ->where('sticky', 0)
                ->where('thread_id', '>', $lastThreadId)
                ->order('thread_id', 'ASC')
                ->limit(self::$batchSize)
                ->fetch();

            if (!$threads->count()) {
                $lastRun[$forumId] = 0;
                continue;
            }

            foreach ($threads as $thread) {
                try {
                    $type = $hardDelete ? 'hard' : 'soft';

                    $deleter = \XF::app()->service('XF:Thread\Deleter', $thread);
                    $deleter->delete($type, '');

                    $lastRun[$forumId] = $thread->thread_id;

                    $totalDeleted++;

                } catch (\Exception $e) {
                    \XF::logError("DZ AutoDelete error (Thread {$thread->thread_id}): " . $e->getMessage());
                }
            }
        }

        // Spremi napredak obrade
// JSON konverzija napretka
$lastRunJson = json_encode($lastRun);

// Spremi napredak obrade
\XF::repository('XF:Option')->updateOption('dzAutoDelete_lastRun', $lastRunJson);

// Spremi zadnje vrijeme pokretanja
\XF::repository('XF:Option')->updateOption('dzAutoDelete_lastRunTime', time());

// Spremi broj obrisanih tema
\XF::repository('XF:Option')->updateOption('dzAutoDelete_lastDeleted', $totalDeleted);

return "DZ AutoDelete batch: obrisano $totalDeleted tema.";

    }
}
