<?php

namespace DZ\AutoDelete\Admin\Controller;

use XF\Admin\Controller\AbstractController;
use XF\Mvc\ParameterBag;

class AutoDeleteStatus extends AbstractController
{
    public function actionIndex()
    {
        // Prikaz statusa
        $viewParams = [
            'lastRun' => \XF::options()->dzAutoDelete_lastRun,
            'lastRunTime' => \XF::options()->dzAutoDelete_lastRunTime,
            'lastDeleted' => \XF::options()->dzAutoDelete_lastDeleted
        ];
        
        return $this->view(
            'DZ\AutoDelete:Status',
            'dz_autodelete_status_page',
            $viewParams
        );
    }

    public function actionRun()
    {
        // pokretanje naše cron funkcije ručno
        \DZ\AutoDelete\XF\Cron\AutoDelete::runAutoDelete();

        // Vrati na indeks stranicu
        return $this->redirect($this->buildLink('dz-autodelete'));
        
        // Ili ako to ne radi, koristi redirect na root admin panela:
        // return $this->redirect($this->buildLink('index/index'));
    }
}